<?php
// Cek apakah sedang update (maintenance mode aktif)
if (file_exists(__DIR__ . "/maintenance.flag")) {
    die("<h1>Sedang update, silakan coba beberapa menit lagi...</h1>");
}
include "config.php";

// Ambil data profil sekolah
$profil = mysqli_fetch_assoc(mysqli_query($conn, "SELECT nama_sekolah, logo FROM profil_sekolah LIMIT 1"));
$nama_sekolah = $profil['nama_sekolah'] ?? 'Nama Sekolah';
$logo = $profil['logo'] ?? 'default.png';
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login Admin</title>
  <style>
    * {
      box-sizing: border-box;
      font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
    }
    body {
      margin: 0;
      padding: 0;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
      background: linear-gradient(135deg, #1e3c72, #2a5298);
      perspective: 1000px;
    }
    .login-container {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      border-radius: 20px;
      box-shadow: 0 10px 25px rgba(0,0,0,0.25),
                  0 4px 8px rgba(255,255,255,0.15) inset;
      width: 100%;
      max-width: 420px;
      padding: 35px 30px;
      transform: rotateX(0deg);
      animation: fadeIn 0.8s ease-in-out;
    }
    .school-header {
      text-align: center;
      margin-bottom: 20px;
    }
    .school-header img {
      max-height: 80px;
      margin-bottom: 10px;
      filter: drop-shadow(0 3px 4px rgba(0,0,0,0.3));
    }
    .school-header h1 {
      font-size: 20px;
      color: #fff;
      margin: 0;
      font-weight: 600;
      text-shadow: 0 2px 4px rgba(0,0,0,0.4);
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #fff;
      font-size: 18px;
      font-weight: normal;
    }
    .info-box {
      background: rgba(255, 255, 255, 0.15);
      border-left: 5px solid #ffd700;
      padding: 12px;
      margin-bottom: 18px;
      font-size: 14px;
      color: #fff;
      border-radius: 8px;
      box-shadow: inset 0 2px 6px rgba(0,0,0,0.2);
    }
    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 14px;
      margin: 10px 0;
      border: none;
      border-radius: 10px;
      font-size: 15px;
      outline: none;
      background: rgba(255, 255, 255, 0.2);
      color: #fff;
      box-shadow: inset 0 2px 5px rgba(0,0,0,0.3);
      transition: all 0.3s ease;
    }
    input::placeholder {
      color: #ddd;
    }
    input:focus {
      background: rgba(255, 255, 255, 0.3);
      transform: scale(1.03);
      box-shadow: 0 0 10px rgba(255,255,255,0.4);
    }
    button {
      width: 100%;
      padding: 14px;
      background: linear-gradient(135deg, #ff9800, #f44336);
      border: none;
      color: white;
      font-size: 16px;
      border-radius: 10px;
      cursor: pointer;
      margin-top: 12px;
      font-weight: bold;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3);
      transition: all 0.3s ease;
    }
    button:hover {
      background: linear-gradient(135deg, #f57c00, #d32f2f);
      transform: translateY(-2px);
      box-shadow: 0 6px 16px rgba(0,0,0,0.4);
    }
    .footer-links {
      margin-top: 20px;
      text-align: center;
      font-size: 14px;
      color: #fff;
    }
    .footer-links a {
      color: #ffd700;
      text-decoration: none;
      margin: 0 8px;
      font-weight: bold;
      transition: color 0.3s ease, transform 0.2s;
    }
    .footer-links a:hover {
      color: #fff;
      transform: scale(1.1);
    }
    .app-version {
      margin-top: 6px;
      text-align: center;
      font-size: 12px;
      color: #ddd;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-15px) rotateX(10deg); }
      to { opacity: 1; transform: translateY(0) rotateX(0deg); }
    }
  </style>
</head>
<body>
  <div class="login-container">
    <div class="school-header">
      <img src="uploads/<?php echo htmlspecialchars($logo); ?>" alt="Logo Sekolah">
      <h1><?php echo htmlspecialchars($nama_sekolah); ?></h1>
    </div>

    <h2>🔑 Login Admin Absensi QR Code</h2>

    <div class="info-box">
      📌 <strong>Fokus Aplikasi:</strong> Mempercepat dan mempermudah pekerjaan <strong>Tenaga Administrasi</strong>, serta mendukung <strong>Tupoksi Wali Kelas</strong> dalam pengelolaan data asesmen siswa.
    </div>

   <div class="info-box">
      👨‍👩‍👧 Orang tua / Wali Siswa dapat memantau kehadiran siswa secara realtime. <br> 
      <strong>Login:</strong> Username = NISN, Password = NISN
    </div>

    <form method="post" action="cek.php">
      <input type="text" name="username" placeholder="Username" required>
      <input type="password" name="password" placeholder="Password" required>
      <button type="submit">Masuk</button>
    </form>
  </div>

  <div class="footer-links">
    <a href="tentang.html">Tentang</a> | 
    <a href="https://shopee.co.id/search?keyword=viralytics">Kontak</a> | 
	  <a href="https://shopee.co.id/search?keyword=viralytics">Unduh</a>
    <div class="app-version">Versi Aplikasi 2025</div>
  </div>
</body>
</html>
