<?php
include 'config.php';

header("Content-Type: application/vnd-ms-excel");
header("Content-Disposition: attachment; filename=rekap_guru.xls");

// Ambil parameter yang sama dengan halaman rekap guru
$tanggal = $_GET['tanggal'] ?? date("Y-m-d");
$tanggal_akhir = $_GET['tanggal_akhir'] ?? $tanggal;
$filter_tanggal = $_GET['filter_tanggal'] ?? 'hari';
$namaFilter = $_GET['nama'] ?? "";
$statusFilter = $_GET['status'] ?? "";

// Cek koneksi database
if (!$conn) {
    die("Koneksi database gagal: " . mysqli_connect_error());
}

// Ambil data kepala sekolah
$profil_query = mysqli_query($conn, "SELECT * FROM profil_sekolah LIMIT 1");
if (!$profil_query) {
    die("Error query profil: " . mysqli_error($conn));
}
$profil = mysqli_fetch_assoc($profil_query);
$kepalaSekolah = $profil['kepala_sekolah'] ?? 'Nama Kepala Sekolah';
$nipKepala = $profil['nip_kepala'] ?? 'NIP Kepala Sekolah';
$namaSekolah = $profil['nama'] ?? 'Nama Sekolah';

// Format periode untuk tampilan
$namaBulan = [
    '01' => 'Januari', '02' => 'Februari', '03' => 'Maret', '04' => 'April',
    '05' => 'Mei', '06' => 'Juni', '07' => 'Juli', '08' => 'Agustus',
    '09' => 'September', '10' => 'Oktober', '11' => 'November', '12' => 'Desember'
];

$bulan = date('m', strtotime($tanggal));
$tahun = date('Y', strtotime($tanggal));
$periode = $namaBulan[$bulan] . ' ' . $tahun;

// Query data absensi guru - disesuaikan dengan struktur dari rekap_guru.php
$sql = "
    SELECT 
        a.id, 
        g.id AS guru_id, 
        g.nip,
        g.nama, 
        a.tanggal,
        a.jam_masuk, 
        a.jam_pulang,
        a.status,
        a.keterangan
    FROM absensi_guru a
    JOIN guru g ON a.guru_id = g.id
    WHERE g.status = 'aktif'
";

// Filter tanggal
if ($filter_tanggal == 'hari') {
    $sql .= " AND a.tanggal = '" . mysqli_real_escape_string($conn, $tanggal) . "'";
} else {
    $sql .= " AND a.tanggal BETWEEN '" . mysqli_real_escape_string($conn, $tanggal) . "' AND '" . mysqli_real_escape_string($conn, $tanggal_akhir) . "'";
}

// Filter lainnya
if ($namaFilter !== "") {
    $sql .= " AND g.nama LIKE '%" . mysqli_real_escape_string($conn, $namaFilter) . "%'";
}
if ($statusFilter !== "") {
    $sql .= " AND a.status = '" . mysqli_real_escape_string($conn, $statusFilter) . "'";
}

// Tambahkan sorting
$sql .= " ORDER BY a.tanggal DESC, g.nama";

$result = mysqli_query($conn, $sql);

// Cek jika query berhasil
if (!$result) {
    die("Error query absensi guru: " . mysqli_error($conn));
}

// Fungsi untuk mendapatkan teks status (sama dengan rekap_guru.php)
function getStatusText($status) {
    switch($status) {
        case 'H': return 'Hadir';
        case 'I': return 'Izin';
        case 'S': return 'Sakit';
        case 'A': return 'Alpa';
        default: return $status;
    }
}

// Fungsi untuk menentukan keterangan berdasarkan jam masuk (sama dengan rekap_guru.php)
function getKeterangan($jam_masuk, $existing_keterangan) {
    // Jika sudah ada keterangan dan bukan Telat/Tepat Waktu, pertahankan
    if (!empty($existing_keterangan) && $existing_keterangan !== 'Tepat Waktu' && $existing_keterangan !== 'Telat') {
        return $existing_keterangan;
    }
    
    // Jika tidak ada jam masuk, kembalikan string kosong
    if (empty($jam_masuk) || $jam_masuk == '-') {
        return $existing_keterangan;
    }
    
    // Tentukan keterangan berdasarkan jam masuk
    $jam_batas = '07:00:00';
    return (strtotime($jam_masuk) > strtotime($jam_batas)) ? 'Telat' : 'Tepat Waktu';
}

// Header laporan
echo "<meta charset='UTF-8'>";
echo "<h2>Rekap Kehadiran Guru</h2>";
echo "<h3>$namaSekolah</h3>";
echo "<p><strong>Periode:</strong> " . ($filter_tanggal == 'hari' ? date("d/m/Y", strtotime($tanggal)) : date("d/m/Y", strtotime($tanggal)) . " - " . date("d/m/Y", strtotime($tanggal_akhir))) . "</p>";
echo "<p><strong>Status:</strong> " . ($statusFilter == '' ? 'Semua Status' : getStatusText($statusFilter)) . "</p>";

// Output tabel absensi
echo "<table border='1'>
<tr>
  <th>No</th>
  <th>Tanggal</th>
  <th>NIP</th>
  <th>Nama Guru</th>
  <th>Jam Masuk</th>
  <th>Jam Pulang</th>
  <th>Status</th>
  <th>Keterangan</th>
</tr>";

$no = 1;
while ($row = mysqli_fetch_assoc($result)) {
  $jamPulang = empty($row['jam_pulang']) ? 'Belum absen pulang' : $row['jam_pulang'];
  $jamMasuk = empty($row['jam_masuk']) ? '-' : $row['jam_masuk'];
  $statusText = getStatusText($row['status']);
  
  // Tentukan keterangan menggunakan fungsi yang sama dengan rekap_guru.php
  $keterangan = getKeterangan($row['jam_masuk'], $row['keterangan']);
  
  echo "<tr>
    <td>$no</td>
    <td>" . date('d/m/Y', strtotime($row['tanggal'])) . "</td>
    <td>{$row['nip']}</td>
    <td>{$row['nama']}</td>
    <td>$jamMasuk</td>
    <td>$jamPulang</td>
    <td>$statusText</td>
    <td>$keterangan</td>
  </tr>";
  $no++;
}
echo "</table>";

// Footer dengan catatan
echo "<br><p><strong>Keterangan:</strong></p>";
echo "<ul>";
echo "<li>H: Hadir</li>";
echo "<li>I: Izin</li>";
echo "<li>S: Sakit</li>";
echo "<li>A: Alpa/Tanpa Keterangan</li>";
echo "</ul>";

// Tanda tangan
echo "<br><br><table width='100%' style='border:0;'>
<tr>
  <td width='50%' align='center'>
    Mengetahui,<br>
    Kepala Sekolah<br><br><br><br>
    <u>$kepalaSekolah</u><br>
    NIP. $nipKepala
  </td>
  <td width='50%' align='center'>
    " . date('d/m/Y') . "<br>
    Koordinator Guru<br><br><br><br>
    <u>(_______________________)</u><br>
    NIP. ____________________
  </td>
</tr>
</table>";

// Tutup koneksi
mysqli_close($conn);
?>