<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard Admin Absensi QR</title>
  <!-- Font Awesome Free CDN -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <style>
    :root {
      --primary: #4361ee;
      --secondary: #3a0ca3;
      --accent: #f72585;
      --success: #4cc9f0;
      --info: #7209b7;
      --warning: #f9c74f;
      --danger: #f94144;
      --dark: #2b2d42;
      --light: #f8f9fa;
      --card-bg: #ffffff;
      --text-primary: #2b2d42;
      --text-secondary: #6c757d;
      --gradient-primary: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
      --gradient-accent: linear-gradient(135deg, #f72585 0%, #b5179e 100%);
      --gradient-success: linear-gradient(135deg, #4cc9f0 0%, #4895ef 100%);
      --shadow: 0 10px 20px rgba(0,0,0,0.12);
      --shadow-hover: 0 15px 30px rgba(0,0,0,0.2);
    }
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #f5f7fa 0%, #e2e8f0 100%);
      margin: 0;
      padding: 0;
      min-height: 100vh;
      overflow-x: hidden;
      color: var(--text-primary);
    }

    /* Notification Bar - Running Text yang Diperbaiki */
    .notification-bar {
      background: var(--gradient-accent);
      color: white;
      padding: 15px 0;
      text-align: center;
      box-shadow: var(--shadow);
      position: relative;
      z-index: 10;
      overflow: hidden;
    }

    .notification-text {
      display: inline-block;
      padding-left: 100%;
      white-space: nowrap;
      animation: marquee 25s linear infinite;
      font-weight: bold;
      font-size: 18px;
      text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
      letter-spacing: 0.5px;
    }

    .notification-text i {
      margin-right: 12px;
      font-size: 20px;
      color: #ffdd00;
      text-shadow: 0 0 5px rgba(0,0,0,0.5);
    }

    @keyframes marquee {
      0%   { transform: translateX(0); }
      100% { transform: translateX(-100%); }
    }

    /* Efek kilatan untuk menarik perhatian */
    .notification-bar:after {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 30px;
      height: 100%;
      background: linear-gradient(90deg, rgba(255,255,255,0.5), rgba(255,255,255,0));
      animation: flash 3s infinite;
    }

    @keyframes flash {
      0%, 100% { opacity: 0; left: -30px; }
      50% { opacity: 1; }
      100% { left: 100%; opacity: 0; }
    }

    header {
      background: var(--gradient-primary);
      color: white;
      padding: 20px;
      text-align: center;
      box-shadow: var(--shadow);
      position: relative;
      z-index: 10;
    }
    
    header h1 {
      font-size: 2.2rem;
      margin-bottom: 5px;
      text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
    }
    
    .user-info {
      font-size: 0.9rem;
      opacity: 0.9;
    }

    h2 {
      margin: 25px 0;
      text-align: center;
      color: var(--dark);
      font-size: 1.8rem;
      text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
      position: relative;
      display: inline-block;
      left: 50%;
      transform: translateX(-50%);
    }
    
    h2:after {
      content: '';
      display: block;
      width: 50px;
      height: 3px;
      background: var(--accent);
      margin: 8px auto;
      border-radius: 2px;
    }

    .dashboard-container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 20px;
      position: relative;
      z-index: 5;
    }

    .menu-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
      gap: 20px;
      margin: 0 auto;
    }

    .menu-card {
      background: var(--card-bg);
      border-radius: 12px;
      overflow: hidden;
      box-shadow: var(--shadow);
      transition: all 0.3s ease;
      position: relative;
      height: 100%;
      display: flex;
      flex-direction: column;
      border: 1px solid rgba(0,0,0,0.05);
    }
    
    .menu-card:hover {
      transform: translateY(-10px) scale(1.03);
      box-shadow: var(--shadow-hover);
    }
    
    .menu-card:before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 5px;
      background: var(--card-color, var(--primary));
    }
    
    .card-content {
      padding: 20px;
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }
    
    .card-icon {
      font-size: 2.5rem;
      margin-bottom: 15px;
      color: var(--card-color, var(--primary));
      text-align: center;
    }
    
    .card-title {
      font-size: 1.1rem;
      font-weight: 600;
      margin-bottom: 10px;
      text-align: center;
      color: var(--text-primary);
    }
    
    .card-desc {
      font-size: 0.85rem;
      color: var(--text-secondary);
      text-align: center;
      margin-bottom: 15px;
      line-height: 1.4;
    }
    
    .card-button {
      display: block;
      text-align: center;
      padding: 10px;
      background: var(--card-color, var(--primary));
      color: white;
      text-decoration: none;
      border-radius: 6px;
      font-weight: 500;
      transition: all 0.2s ease;
      margin-top: auto;
      border: none;
      cursor: pointer;
    }
    
    .card-button:hover {
      background: var(--card-dark, var(--secondary));
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }

    footer {
      margin-top: 40px;
      background: var(--dark);
      color: white;
      text-align: center;
      padding: 15px;
      font-size: 14px;
      position: relative;
      z-index: 10;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .menu-grid {
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
      }
      
      header h1 {
        font-size: 1.8rem;
      }
      
      .notification-text {
        font-size: 16px;
      }
    }
    
    @media (max-width: 480px) {
      .menu-grid {
        grid-template-columns: 1fr;
      }
      
      .notification-text {
        font-size: 14px;
        animation: marquee 30s linear infinite;
      }
    }
  </style>
</head>
<body>
  <!-- Notification Bar - Running Text yang Diperbaiki -->
  <div class="notification-bar">
    <div class="notification-text">
      <i class="fas fa-bullhorn"></i> فَمَنْ يَّعْمَلْ مِثْقَالَ ذَرَّةٍ خَيْرًا يَّرَهٗۚ ۝٧ Siapa yang mengerjakan kebaikan seberat zarah, dia akan melihat (balasan)-nya.Az-Zalzalah.Ayat 7
    </div>
  </div>

  <header>
    <h1>Dashboard Admin</h1>
    <div class="user-info">Selamat datang, <?php echo $_SESSION['username']; ?> | Role: <?php echo $_SESSION['role']; ?></div>
  </header>

  <div class="dashboard-container">
    <h2>Menu Utama</h2>
    
    <div class="menu-grid">
      <!-- Data Guru -->
      <div class="menu-card" style="--card-color: #25a244; --card-dark: #1b4332;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-chalkboard-teacher"></i></div>
          <div class="card-title">Data Guru</div>
          <div class="card-desc">Kelola data guru, NIP, mata pelajaran, dan barcode</div>
          <a href="guru.php" class="card-button">Akses Menu</a>
        </div>
      </div>

      <!-- Rekap Kehadiran Guru -->
      <div class="menu-card" style="--card-color: #7209b7; --card-dark: #560bad;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-chart-column"></i></div>
          <div class="card-title">Rekap Kehadiran Guru</div>
          <div class="card-desc">Lihat rekap kehadiran guru per periode</div>
          <a href="rekap_guru.php" class="card-button">Akses Menu</a>
        </div>
      </div>

      <!-- Data Siswa -->
      <div class="menu-card" style="--card-color: #4361ee; --card-dark: #3a0ca3;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-user-graduate"></i></div>
          <div class="card-title">Data Siswa</div>
          <div class="card-desc">Kelola data siswa, NIS, NISN, kelas, dan kontak</div>
          <a href="siswa.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- SCAN QR + WA API OTOMATIS -->
      <div class="menu-card" style="--card-color: #3a0ca3; --card-dark: #480ca8;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-qrcode"></i></div>
          <div class="card-title">SCAN QR + WA API OTOMATIS</div>
          <div class="card-desc">Scan QR dengan notifikasi WhatsApp otomatis</div>
          <a href="scan_wa_api.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Pengaturan Key API WA -->
      <div class="menu-card" style="--card-color: #f72585; --card-dark: #b5179e;">
        <div class="card-content">
          <div class="card-icon"><i class="fab fa-whatsapp"></i></div>
          <div class="card-title">Pengaturan Key API WA</div>
          <div class="card-desc">Kelola kunci API untuk integrasi WhatsApp</div>
          <a href="key_wa_sidobe.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Siswa Belum Hadir -->
      <div class="menu-card" style="--card-color: #f94144; --card-dark: #f3722c;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-user"></i></div>
          <div class="card-title">Siswa Belum Hadir</div>
          <div class="card-desc">Lihat daftar siswa yang belum melakukan absensi</div>
          <a href="belum_absensi.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Isi S/I/A -->
      <div class="menu-card" style="--card-color: #4361ee; --card-dark: #3a0ca3;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-clipboard-check"></i></div>
          <div class="card-title">Isi S/I/A</div>
          <div class="card-desc">Input data Sakit, Izin, atau Alpha untuk siswa</div>
          <a href="absensi.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Jam Waktu Absensi -->
      <div class="menu-card" style="--card-color: #7209b7; --card-dark: #560bad;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-clock"></i></div>
          <div class="card-title">Jam Waktu Absensi</div>
          <div class="card-desc">Atur jadwal dan batas waktu absensi</div>
          <a href="jam_absensi.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Rekap Bulanan -->
      <div class="menu-card" style="--card-color: #4cc9f0; --card-dark: #4895ef;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-calendar-days"></i></div>
          <div class="card-title">Rekap Bulanan</div>
          <div class="card-desc">Lihat rekap absensi per bulan</div>
          <a href="rekap_bulanan.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Rekap Bulanan Guru -->
      <div class="menu-card" style="--card-color: #f9c74f; --card-dark: #f8961e;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-chalkboard-teacher"></i></div>
          <div class="card-title">Rekap Bulanan Guru</div>
          <div class="card-desc">Lihat rekap kehadiran guru per bulan</div>
          <a href="rekap_bulanan_guru.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Prosentase Kehadiran -->
      <div class="menu-card" style="--card-color: #f72585; --card-dark: #b5179e;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-chart-pie"></i></div>
          <div class="card-title">Prosentase Kehadiran</div>
          <div class="card-desc">Statistik persentase kehadiran siswa</div>
          <a href="hadir.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Hari Libur -->
      <div class="menu-card" style="--card-color: #90be6d; --card-dark: #43aa8b;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-plane"></i></div>
          <div class="card-title">Hari Libur</div>
          <div class="card-desc">Kelola hari libur dan cuti bersama</div>
          <a href="libur.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Export Excel -->
      <div class="menu-card" style="--card-color: #43aa8b; --card-dark: #4d908e;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-file-excel"></i></div>
          <div class="card-title">Export Excel</div>
          <div class="card-desc">Ekspor data absensi ke format Excel</div>
          <a href="export.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Grup WA -->
      <div class="menu-card" style="--card-color: #25d366; --card-dark: #128c7e;">
        <div class="card-content">
          <div class="card-icon"><i class="fab fa-whatsapp"></i></div>
          <div class="card-title">Grup WA</div>
          <div class="card-desc">Bergabung dengan grup WhatsApp komunitas</div>
          <a href="https://chat.whatsapp.com/KtdYP6nx3eZLVhqJkQ1Zbs?mode=ac_t" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Kirim WA Orang Tua/Wali Siswa -->
      <div class="menu-card" style="--card-color: #25d366; --card-dark: #128c7e;">
        <div class="card-content">
          <div class="card-icon"><i class="fab fa-whatsapp"></i></div>
          <div class="card-title">Kirim WA Orang Tua/Wali</div>
          <div class="card-desc">Kirim pesan WhatsApp ke orang tua/wali siswa</div>
          <a href="wa-wali-siswa.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Profil Sekolah -->
      <div class="menu-card" style="--card-color: #577590; --card-dark: #4d908e;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-school"></i></div>
          <div class="card-title">Profil Sekolah</div>
          <div class="card-desc">Kelola informasi dan identitas sekolah</div>
          <a href="profil.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Wali Kelas -->
      <div class="menu-card" style="--card-color: #7209b7; --card-dark: #560bad;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-chalkboard-teacher"></i></div>
          <div class="card-title">Wali Kelas</div>
          <div class="card-desc">Kelola data wali kelas dan pembagiannya</div>
          <a href="wali_kelas.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Hapus/Kosongkan Data -->
      <div class="menu-card" style="--card-color: #f94144; --card-dark: #f3722c;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-trash"></i></div>
          <div class="card-title">Hapus/Kosongkan Data</div>
          <div class="card-desc">Kosongkan data absensi dan siswa</div>
          <a href="kosongkan_data.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Backup Restore -->
      <div class="menu-card" style="--card-color: #4cc9f0; --card-dark: #4895ef;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-rotate"></i></div>
          <div class="card-title">Backup Restore</div>
          <div class="card-desc">Backup dan restore database sistem</div>
          <a href="backup_restore.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Pengaturan -->
      <div class="menu-card" style="--card-color: #577590; --card-dark: #4d908e;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-gear"></i></div>
          <div class="card-title">Pengaturan</div>
          <div class="card-desc">Konfigurasi sistem dan preferensi</div>
          <a href="pengaturan.php" class="card-button">Akses Menu</a>
        </div>
      </div>
      
      <!-- Logout -->
      <div class="menu-card" style="--card-color: #f94144; --card-dark: #f3722c;">
        <div class="card-content">
          <div class="card-icon"><i class="fas fa-right-from-bracket"></i></div>
          <div class="card-title">Logout</div>
          <div class="card-desc">Keluar dari sistem administrasi</div>
          <a href="logout.php" class="card-button">Keluar</a>
        </div>
      </div>
    </div>
  </div>

  <footer>
    Versi Aplikasi: 4.00 | &copy; <?php echo date('Y'); ?> Sistem Absensi QR
  </footer>

  <script>
    // Efek hover untuk menu card dengan delay berbeda
    const cards = document.querySelectorAll('.menu-card');
    cards.forEach((card, index) => {
      card.style.transitionDelay = `${index * 0.03}s`;
    });
  </script>
</body>
</html>